<?php
require('fpdf.php');

class PDF extends FPDF
{
// Load data
function LoadData($file)
{
    // Read file lines
    $lines = file($file);
    $data = array();
    foreach($lines as $line)
        $data[] = explode(';',trim($line));
    return $data;
}

// Simple table
function BasicTable($header, $data)
{
    // Header
    foreach($header as $col)
        $this->Cell(40,17,$col,1);
    $this->Ln();
    // Data
    foreach($data as $row)
    {
        foreach($row as $col)
            $this->Cell(40,10,$col,1);
        $this->Ln();
    }
}

}

$pdf = new PDF();


$pdf->AddPage();

$pdf->SetFont('Arial','',10);
$pdf->SetDrawColor(10, 191, 46);
$pdf->Cell(120,10, ''.$pdf->Image('aura_logo.png',10,10,60).'', 0, 0, 'L');
$pdf->Cell(10,10, '', 0, 0, 'R');   
$pdf->Cell(60,10, '', 'TRL', 1, 'R');

$pdf->SetTextColor(10, 191, 46);
$pdf->Cell(130,10, '', 'R', 0, 'L');
$pdf->SetFont('Arial','',20);
$pdf->Cell(60,10, 'PAID', 'R', 1, 'C');

$y = $pdf->GetY();
$x = $pdf->GetX();

$w = '120';
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0, 0, 0);

$pdf->MultiCell($w,5, 'PH: +92839383, gMAIL : testtingg@gmial.com, addesss : merku thodarchimalai, Coiambatore - 72393', 0, 'L');
$pdf->SetXY($x + $w, $y);
$x = $pdf->GetX();
$pdf->SetTextColor(10, 191, 46);
$pdf->Cell(10,10, '', 0, 0, 'R');
$pdf->Cell(60,10, '', 'BRL', 1, 'R');

$pdf->Output();
?>